const express = require("express");
const mysql = require("mysql2/promise");
const jwt = require("jsonwebtoken");
const app = express();
const cors = require("cors");
const axios = require("axios");
const fs = require("fs");
const multer = require("multer");
const path = require("path");
const moments = require("moment-timezone");
const moment = require("moment");

const corsOptions = {
  origin: [
    "https://member.mathenoid.com",
    "https://admin.mathenoid.com",
    "http://localhost:3000",
    "http://localhost:3001",
  ], // Allow only this origins
  methods: "GET,HEAD,PUT,PATCH,POST,DELETE,UPDATE",
  preflightContinue: false,
  optionsSuccessStatus: 204,
};

app.use(cors(corsOptions));

app.use(express.json());

// app.use("/repository", express.static(path.join(__dirname, "repository")));
// app.use("/profileImages", express.static(path.join(__dirname, "profileImages")));

const dbConfigt = {
  host: "mathenoid.com",
  user: "mathenoi_mpesapays",
  password: "mpesapays.1",
  database: "mathenoi_mpesapays",
};

const dbConfig = {
  host: "mathenoid.com",
  user: "mathenoi_microfinance",
  password: "^l)kgKDC9JCC",
  database: "mathenoi_kiama",
};

// const dbConfigt = {
//   host: "localhost",
//   user: "mathenoi_housing1",
//   password: ")HtUW7!U.cnd",
//   database: "mathenoi_housing1",
// };
// Ensure profileImages directory exists
const profileImagesDir = path.join(__dirname, "profileImages");
if (!fs.existsSync(profileImagesDir)) {
  fs.mkdirSync(profileImagesDir);
}

// Configure multer for profile image uploads
const profileImageStorage = multer.diskStorage({
  destination: (req, file, cb) => {
    cb(null, profileImagesDir);
  },
  filename: (req, file, cb) => {
    const uniqueSuffix = Date.now() + "-" + Math.round(Math.random() * 1e9);
    cb(
      null,
      file.fieldname + "-" + uniqueSuffix + path.extname(file.originalname)
    );
  },
});

const uploadProfileImage = multer({ storage: profileImageStorage });

// New API endpoint to search songs by title or artist
app.get("/api/songs/search", async (req, res) => {
  const connection = await mysql.createConnection(dbConfig);
  try {
    const { query } = req.query;
    const [rows] = await connection.execute(
      `
      SELECT 
        s.*, 
        c.homechurch as homeChurch,
        COUNT(*) OVER (PARTITION BY s.artist) a/s songCount
      FROM 
        songs s
      LEFT JOIN 
        colleagues c ON s.artist = c.name
      WHERE 
        s.title LIKE ? OR s.artist LIKE ?
      ORDER BY 
        s.addedOn DESC
    `,
      [`%${query}%`, `%${query}%`]
    );
    res.json({ success: true, songs: rows });
  } catch (error) {
    console.error("Error searching songs:", error);
    res.status(500).json({ success: false, message: "Error searching songs" });
  } finally {
    await connection.end();
  }
});

// New API endpoint to get user role
app.post("/api/getUserRole", async (req, res) => {
  const connection = await mysql.createConnection(dbConfig);
  try {
    const { user } = req.body;

    if (!user) {
      return res
        .status(400)
        .json({ success: false, message: "User not provided" });
    }

    const [rows] = await connection.execute(
      "SELECT role FROM colleagues WHERE name = ?",
      [user]
    );

    if (rows.length === 0) {
      return res
        .status(404)
        .json({ success: false, message: "User not found" });
    }

    const userRole = rows[0].role;
    res.json({ success: true, role: userRole });
  } catch (error) {
    console.error("Error fetching user role:", error);
    res
      .status(500)
      .json({ success: false, message: "Error fetching user role" });
  } finally {
    await connection.end();
  }
});

// New API endpoint to get all members with their song counts and home churches
app.get("/api/members", async (req, res) => {
  const connection = await mysql.createConnection(dbConfig);
  try {
    const [rows] = await connection.execute(`
      SELECT 
        c.name, 
        c.homechurch, 
        c.role,
        COUNT(s.id) as songCount
      FROM 
        colleagues c
      LEFT JOIN 
        songs s ON c.name = s.artist
      GROUP BY 
        c.name, c.homechurch, c.role
      ORDER BY 
        c.name
    `);

    const members = rows.map((row) => ({
      name: row.name,
      homechurch: row.homechurch,
      role: row.role,
      songCount: row.songCount,
    }));

    res.json({ success: true, members: members });
  } catch (error) {
    console.error("Error fetching members:", error);
    res.status(500).json({ success: false, message: "Error fetching members" });
  } finally {
    await connection.end();
  }
});

// New API endpoint to toggle admin status
app.put("/api/members/:name/toggleAdmin", async (req, res) => {
  const connection = await mysql.createConnection(dbConfig);
  try {
    const { name } = req.params;
    const { currentUser } = req.body;

    // Check if the current user is an admin
    const [adminCheck] = await connection.execute(
      "SELECT role FROM colleagues WHERE name = ?",
      [currentUser]
    );

    if (adminCheck.length === 0 || adminCheck[0].role !== "admin") {
      return res.status(403).json({
        success: false,
        message: "You do not have permission to perform this action",
      });
    }

    // Get the current role of the member
    const [memberRole] = await connection.execute(
      "SELECT role FROM colleagues WHERE name = ?",
      [name]
    );

    if (memberRole.length === 0) {
      return res
        .status(404)
        .json({ success: false, message: "Member not found" });
    }

    const newRole = memberRole[0].role === "admin" ? "member" : "admin";

    // Update the member's role
    const [result] = await connection.execute(
      "UPDATE colleagues SET role = ? WHERE name = ?",
      [newRole, name]
    );

    if (result.affectedRows === 0) {
      res.status(404).json({ success: false, message: "Member not found" });
    } else {
      res.json({ success: true, message: `Member role updated to ${newRole}` });
    }
  } catch (error) {
    console.error("Error toggling admin status:", error);
    res
      .status(500)
      .json({ success: false, message: "Error toggling admin status" });
  } finally {
    await connection.end();
  }
});

//api to delete member
app.delete("/api/members/:name", async (req, res) => {
  const connection = await mysql.createConnection(dbConfig);
  try {
    const name = decodeURIComponent(req.params.name);
    const { currentUser } = req.body;

    // Check if the current user is an admin
    const [adminCheck] = await connection.execute(
      "SELECT role FROM colleagues WHERE name = ?",
      [currentUser]
    );

    if (adminCheck.length === 0 || adminCheck[0].role !== "admin") {
      return res.status(403).json({
        success: false,
        message: "You do not have permission to perform this action",
      });
    }

    // Prevent deleting yourself
    if (name === currentUser) {
      return res.status(400).json({
        success: false,
        message: "You cannot delete your own account",
      });
    }

    // Start a transaction
    await connection.beginTransaction();

    // Update songs
    await connection.execute(
      "UPDATE songs SET artist = CONCAT(?, ' (deleted)') WHERE artist = ?",
      [name, name]
    );

    // Delete the member
    const [result] = await connection.execute(
      "DELETE FROM colleagues WHERE name = ?",
      [name]
    );

    // Commit the transaction
    await connection.commit();

    if (result.affectedRows === 0) {
      res.status(404).json({ success: false, message: "Member not found" });
    } else {
      res.json({ success: true, message: "Member deleted successfully" });
    }
  } catch (error) {
    // Rollback in case of error
    await connection.rollback();
    console.error("Error deleting member:", error);
    res.status(500).json({ success: false, message: "Error deleting member" });
  } finally {
    await connection.end();
  }
});

// API endpoint to add a new song
app.post("/api/songs", async (req, res) => {
  const connection = await mysql.createConnection(dbConfig);
  try {
    const { title, content, artist } = req.body;
    const [result] = await connection.execute(
      "INSERT INTO songs (title, content, artist) VALUES (?, ?, ?)",
      [title, content, artist]
    );
    res.json({
      success: true,
      message: "Song added successfully",
      id: result.insertId,
    });
  } catch (error) {
    console.error("Error adding song:", error);
    res.status(500).json({ success: false, message: "Error adding song" });
  } finally {
    await connection.end();
  }
});

// New API endpoint to update a song
app.put("/api/songs/:id", async (req, res) => {
  const connection = await mysql.createConnection(dbConfig);
  try {
    const { id } = req.params;
    const { title, content, editedBy } = req.body;
    const editedOn = moment().format("YYYY-MM-DD HH:mm:ss");

    const [result] = await connection.execute(
      "UPDATE songs SET title = ?, content = ?, editedBy = ?, editedOn = ? WHERE id = ?",
      [title, content, editedBy, editedOn, id]
    );

    if (result.affectedRows === 0) {
      res.status(404).json({ success: false, message: "Song not found" });
    } else {
      res.json({ success: true, message: "Song updated successfully" });
    }
  } catch (error) {
    console.error("Error updating song:", error);
    res.status(500).json({ success: false, message: "Error updating song" });
  } finally {
    await connection.end();
  }
});

// API endpoint to get all songs with artist's home church
app.get("/api/songs", async (req, res) => {
  const connection = await mysql.createConnection(dbConfig);
  try {
    const [rows] = await connection.execute(`
      SELECT 
        s.*, 
        c.homechurch as homeChurch,
        COUNT(*) OVER (PARTITION BY s.artist) as songCount
      FROM 
        songs s
      LEFT JOIN 
        colleagues c ON s.artist = c.name
      ORDER BY 
        s.addedOn DESC
    `);
    res.json({ success: true, songs: rows });
  } catch (error) {
    console.error("Error fetching songs:", error);
    res.status(500).json({ success: false, message: "Error fetching songs" });
  } finally {
    await connection.end();
  }
});

// New API endpoint to get a specific song by ID
app.get("/api/songs/:id", async (req, res) => {
  const connection = await mysql.createConnection(dbConfig);
  try {
    const [rows] = await connection.execute(
      "SELECT * FROM songs WHERE id = ?",
      [req.params.id]
    );

    if (rows.length === 0) {
      res.status(404).json({ success: false, message: "Song not found" });
    } else {
      res.json({ success: true, song: rows[0] });
    }
  } catch (error) {
    console.error("Error fetching song details:", error);
    res
      .status(500)
      .json({ success: false, message: "Error fetching song details" });
  } finally {
    await connection.end();
  }
});

// Updated API endpoint to update a user's profile by ID
app.put(
  "/api/profile/:id",
  uploadProfileImage.single("profileImage"),
  async (req, res) => {
    let connection;
    try {
      connection = await mysql.createConnection(dbConfig);
      await connection.beginTransaction();

      const { id } = req.params;
      const { name, email, phone, homechurch } = req.body;
      let profileImageUrl = null;

      if (req.file) {
        profileImageUrl = `/profileImages/${req.file.filename}`;
      }

      // Fetch the current user's name
      const [currentUser] = await connection.execute(
        "SELECT name FROM colleagues WHERE id = ?",
        [id]
      );

      if (currentUser.length === 0) {
        await connection.rollback();
        return res
          .status(404)
          .json({ success: false, message: "User not found" });
      }

      const oldName = currentUser[0].name;

      let query =
        "UPDATE colleagues SET name = ?, email = ?, phone = ?, homechurch = ?";
      let params = [name, email, phone, homechurch];

      if (profileImageUrl) {
        query += ", profileImageUrl = ?";
        params.push(profileImageUrl);
      }

      query += " WHERE id = ?";
      params.push(id);

      const [result] = await connection.execute(query, params);

      if (result.affectedRows === 0) {
        await connection.rollback();
        return res
          .status(404)
          .json({ success: false, message: "User not found" });
      }

      // If the name has changed, update the songs table
      if (oldName !== name) {
        const [songUpdateResult] = await connection.execute(
          "UPDATE songs SET artist = ? WHERE artist = ?",
          [name, oldName]
        );
        console.log(`Updated ${songUpdateResult.affectedRows} songs`);
      }

      await connection.commit();
      res.json({ success: true, message: "Profile updated successfully" });
    } catch (error) {
      if (connection) await connection.rollback();
      console.error("Error updating profile:", error);
      res
        .status(500)
        .json({ success: false, message: "Error updating profile" });
    } finally {
      if (connection) await connection.end();
    }
  }
);

// Update the existing profile fetch endpoint to include the user's ID
app.post("/api/profile", async (req, res) => {
  const connection = await mysql.createConnection(dbConfig);
  try {
    const { user } = req.body;

    const [rows] = await connection.execute(
      "SELECT id, name, email, homechurch, phone, profileImageUrl FROM colleagues WHERE name = ?",
      [user]
    );

    if (rows.length > 0) {
      const user = rows[0];
      res.json({
        success: true,
        user: {
          id: user.id,
          name: user.name,
          email: user.email,
          homechurch: user.homechurch,
          phone: user.phone,
          profileImageUrl: user.profileImageUrl,
        },
      });
    } else {
      res.status(404).json({ success: false, message: "User not found" });
    }
  } catch (error) {
    console.error("Error fetching user profile:", error);
    res.status(500).json({ success: false, message: "Internal server error" });
  } finally {
    await connection.end();
  }
});

app.post("/api/check-existing-user", async (req, res) => {
  const connection = await mysql.createConnection(dbConfig);
  try {
    const { name, email, phone, church } = req.body;

    // Helper function to trim values
    const trimValue = (value) =>
      typeof value === "string" ? value.trim() : value;

    // Check in colleagues table
    const [existingColleagues] = await connection.execute(
      "SELECT * FROM colleagues WHERE TRIM(name) = ? AND TRIM(email) = ? AND TRIM(phone) = ? AND TRIM(homechurch) = ?",
      [name, email, phone, church]
    );

    // Check if colleague email exists in colleagues  table
    const [existingColleagueEmail] = await connection.execute(
      "SELECT * FROM colleagues WHERE TRIM(email) = ? ",
      [email]
    );

    // Check if colleague email exists in colleaguesApplied table
    const [existingColleagueAppliedEmail] = await connection.execute(
      "SELECT * FROM colleaguesApplied WHERE TRIM(email) = ? ",
      [email]
    );

    // Check in colleaguesApplied table
    const [existingApplied] = await connection.execute(
      "SELECT * FROM colleaguesApplied WHERE TRIM(name) = ? AND TRIM(email) = ? AND TRIM(phone) = ? AND TRIM(homechurch) = ?",
      [name, email, phone, church]
    );

    // Trim the database responses
    const trimmedExistingColleagues = existingColleagues.map((colleague) => ({
      ...colleague,
      name: trimValue(colleague.name),
      email: trimValue(colleague.email),
      phone: trimValue(colleague.phone),
      homechurch: trimValue(colleague.homechurch),
    }));

    const trimmedExistingApplied = existingApplied.map((applicant) => ({
      ...applicant,
      name: trimValue(applicant.name),
      email: trimValue(applicant.email),
      phone: trimValue(applicant.phone),
      homechurch: trimValue(applicant.homechurch),
    }));

    if (trimmedExistingColleagues.length > 0) {
      return res.json({
        success: false,
        exists: true,
        message: "A user with these these details already exists.",
        type: "member",
      });
    }

    if (trimmedExistingApplied.length > 0) {
      return res.json({
        success: false,
        exists: true,
        message: "An application with these details already exists.",
        type: "applicant",
      });
    }

    if (existingColleagueEmail.length > 0) {
      return res.json({
        success: false,
        exists: true,
        message: "A member with the email already exists.",
        type: "member",
      });
    }

    if (existingColleagueAppliedEmail.length > 0) {
      return res.json({
        success: false,
        exists: true,
        message: "An application with the email already exists.",
        type: "applicant",
      });
    }

    res.json({ success: true, exists: false });
  } catch (error) {
    console.error("Error checking existing user:", error);
    res.status(500).json({ success: false, errors: error.message });
  } finally {
    await connection.end();
  }
});

// Update the existing signup endpoint

app.post(
  "/api/signup",
  uploadProfileImage.single("profileImage"),
  async (req, res) => {
    let connection;
    try {
      const { name, email, password, church, phone } = req.body;
      const profileImageUrl = req.file
        ? `/profileImages/${req.file.filename}`
        : null;

      // Check if user exists using the existing API
      const checkUserResponse = await axios.post(
        "https://kiamabackend.mathenoid.com/api/check-existing-user",
        {
          name,
          email,
          phone,
          church,
        }
      );

      if (checkUserResponse.data.exists) {
        // If the user uploaded an image, delete it since we're not going to use it
        if (req.file) {
          const imagePath = path.join(
            __dirname,
            "profileImages",
            req.file.filename
          );
          fs.unlink(imagePath, (err) => {
            if (err) console.error("Error deleting unused profile image:", err);
          });
        }

        return res.status(400).json({
          success: false,
          message: checkUserResponse.data.message,
          type: checkUserResponse.data.type,
        });
      }

      // If user doesn't exist, proceed with signup
      connection = await mysql.createConnection(dbConfig);

      const [result] = await connection.execute(
        "INSERT INTO colleaguesApplied (name, email, homechurch, password, profileImageUrl, phone) VALUES (?, ?, ?, ?, ?, ?)",
        [name, email, church, password, profileImageUrl, phone]
      );

      res.json({
        success: true,
        message:
          "Successfully applied for membership. Please await admin approval to access the system.",
      });
    } catch (error) {
      console.error("Error during signup:", error);
      res.status(500).json({ success: false, errors: error.message });
    } finally {
      if (connection) await connection.end();
    }
  }
);

// New API endpoint to get all applied members
app.get("/api/applied-members", async (req, res) => {
  const connection = await mysql.createConnection(dbConfig);
  try {
    const [rows] = await connection.execute(`
      SELECT name, email, homechurch, phone
      FROM colleaguesApplied
      ORDER BY name
    `);
    res.json({ success: true, appliedMembers: rows });
  } catch (error) {
    console.error("Error fetching applied members:", error);
    res
      .status(500)
      .json({ success: false, message: "Error fetching applied members" });
  } finally {
    await connection.end();
  }
});

// New API endpoint to accept an applied member
app.post("/api/accept-member", async (req, res) => {
  const connection = await mysql.createConnection(dbConfig);
  try {
    const { name } = req.body;

    await connection.beginTransaction();

    // Fetch member data from colleaguesApplied
    const [memberData] = await connection.execute(
      "SELECT * FROM colleaguesApplied WHERE name = ?",
      [name]
    );

    if (memberData.length === 0) {
      await connection.rollback();
      return res
        .status(404)
        .json({ success: false, message: "Applied member not found" });
    }

    // Insert member into colleagues table
    await connection.execute(
      "INSERT INTO colleagues (name, email, homechurch, password, profileImageUrl, phone, role) VALUES (?, ?, ?, ?, ?, ?, ?)",
      [
        memberData[0].name,
        memberData[0].email,
        memberData[0].homechurch,
        memberData[0].password,
        memberData[0].profileImageUrl,
        memberData[0].phone,
        "member",
      ]
    );

    // Remove member from colleaguesApplied table
    await connection.execute("DELETE FROM colleaguesApplied WHERE name = ?", [
      name,
    ]);

    await connection.commit();
    res.json({ success: true, message: "Member accepted successfully" });
  } catch (error) {
    await connection.rollback();
    console.error("Error accepting member:", error);
    res.status(500).json({ success: false, message: "Error accepting member" });
  } finally {
    await connection.end();
  }
});

app.delete("/api/dismiss-member/:name", async (req, res) => {
  const connection = await mysql.createConnection(dbConfig);
  try {
    const name = decodeURIComponent(req.params.name);

    const [result] = await connection.execute(
      "DELETE FROM colleaguesApplied WHERE name = ?",
      [name]
    );

    if (result.affectedRows === 0) {
      res
        .status(404)
        .json({ success: false, message: "Applied member not found" });
    } else {
      res.json({
        success: true,
        message: "Applied member dismissed successfully",
      });
    }
  } catch (error) {
    console.error("Error dismissing applied member:", error);
    res
      .status(500)
      .json({ success: false, message: "Error dismissing applied member" });
  } finally {
    await connection.end();
  }
});

// Creating API for hymhub login
app.post("/loginColleagues", async (req, res) => {
  const connection = await mysql.createConnection(dbConfig);

  try {
    const [rows] = await connection.execute(
      "SELECT * FROM colleagues WHERE name = ?",
      [req.body.username]
    );

    if (rows.length > 0) {
      const user = rows[0];
      const passCompare = req.body.password === user.password;

      if (passCompare) {
        const data = {
          user: {
            id: user.id,
          },
        };

        const token = jwt.sign(data, "secret_ecom");

        // Fetch data from all three tables
        const [colleagues] = await connection.execute(
          "SELECT * FROM colleagues"
        );
        const [colleaguesApplied] = await connection.execute(
          "SELECT * FROM colleaguesApplied"
        );
        const [songs] = await connection.execute("SELECT * FROM songs");

        res.json({
          success: true,
          token,
          data: {
            colleagues,
            colleaguesApplied,
            songs,
          },
        });
      } else {
        res.json({ success: false, errors: "Wrong Password" });
      }
    } else {
      res.json({ success: false, errors: "Wrong Username" });
    }
  } catch (error) {
    res.status(500).json({ success: false, errors: error.message });
  } finally {
    await connection.end();
  }
});

// API endpoint to verify user for password reset
app.post("/api/forgot-password/verify", async (req, res) => {
  const connection = await mysql.createConnection(dbConfig);
  try {
    const { phone, homeChurch } = req.body;
    const [rows] = await connection.execute(
      "SELECT * FROM colleagues WHERE phone = ? AND homechurch = ?",
      [phone, homeChurch]
    );

    if (rows.length > 0) {
      res.json({ success: true, message: "User verified" });
    } else {
      res.json({
        success: false,
        message: "No user found with the provided information",
      });
    }
  } catch (error) {
    console.error("Error verifying user:", error);
    res.status(500).json({ success: false, message: "Error verifying user" });
  } finally {
    await connection.end();
  }
});

// New API endpoint to delete a song
app.delete("/api/songs/:id", async (req, res) => {
  const connection = await mysql.createConnection(dbConfig);
  try {
    const { id } = req.params;

    const [result] = await connection.execute(
      "DELETE FROM songs WHERE id = ?",
      [id]
    );

    if (result.affectedRows === 0) {
      res.status(404).json({ success: false, message: "Song not found" });
    } else {
      res.json({ success: true, message: "Song deleted successfully" });
    }
  } catch (error) {
    console.error("Error deleting song:", error);
    res.status(500).json({ success: false, message: "Error deleting song" });
  } finally {
    await connection.end();
  }
});

// API endpoint to reset password
app.post("/api/forgot-password/reset", async (req, res) => {
  const connection = await mysql.createConnection(dbConfig);
  try {
    const { phone, homeChurch, newPassword } = req.body;
    const [result] = await connection.execute(
      "UPDATE colleagues SET password = ? WHERE phone = ? AND homechurch = ?",
      [newPassword, phone, homeChurch]
    );

    if (result.affectedRows > 0) {
      res.json({ success: true, message: "Password updated successfully" });
    } else {
      res.json({ success: false, message: "Failed to update password" });
    }
  } catch (error) {
    console.error("Error resetting password:", error);
    res
      .status(500)
      .json({ success: false, message: "Error resetting password" });
  } finally {
    await connection.end();
  }
});

// Configure multer for file uploads
const storage = multer.diskStorage({
  destination: (req, file, cb) => {
    cb(null, "repository");
  },
  filename: (req, file, cb) => {
    cb(null, file.originalname);
  },
});

const upload = multer({ storage });

// API to get repository data
app.get("/api/repository", async (req, res) => {
  const connection = await mysql.createConnection(dbConfig);

  try {
    const [rows] = await connection.execute("SELECT * FROM repository");

    if (rows.length > 0) {
      res.json(rows);
    } else {
      res
        .status(404)
        .json({ success: false, errors: "No repository items found" });
    }
  } catch (error) {
    console.error("Error fetching repository data:", error);
    res.status(500).json({ success: false, errors: error.message });
  } finally {
    await connection.end();
  }
});

// API to upload a file and save the URL to the repository table
app.post("/api/repository/upload", upload.single("item"), async (req, res) => {
  const connection = await mysql.createConnection(dbConfig);

  try {
    const { date } = req.body;
    const file = req.file;

    if (!file) {
      return res
        .status(400)
        .json({ success: false, errors: "No file uploaded" });
    }

    const fileUrl = `/repository/${file.filename}`;

    // Insert the file URL into the repository table
    await connection.execute(
      "INSERT INTO repository (date, file_url) VALUES (?, ?)",
      [date, fileUrl]
    );

    res.json({ success: true, message: "File uploaded successfully", fileUrl });
  } catch (error) {
    res.status(500).json({ success: false, errors: error.message });
  } finally {
    await connection.end();
  }
});

// Creating API for member login
app.post("/login", async (req, res) => {
  const connection = await mysql.createConnection(dbConfig);

  try {
    const [rows] = await connection.execute(
      "SELECT * FROM members WHERE name = ? AND phone_number = ?",
      [req.body.username, req.body.phone]
    );

    if (rows.length > 0) {
      const user = rows[0];
      const passCompare = req.body.phone === user.phone_number;

      if (passCompare) {
        const data = {
          user: {
            id: user.id,
          },
        };

        const token = jwt.sign(data, "secret_ecom");
        res.json({ success: true, token });
      } else {
        res.json({ success: false, errors: "Wrong Password" });
      }
    } else {
      res.json({ success: false, errors: "Wrong Username" });
    }
  } catch (error) {
    res.status(500).json({ success: false, errors: error.message });
  } finally {
    await connection.end();
  }
});

// Creating API for admin login
app.post("/loginAdmin", async (req, res) => {
  const connection = await mysql.createConnection(dbConfig);

  try {
    const [rows] = await connection.execute(
      "SELECT * FROM admins WHERE name = ?",
      [req.body.username]
    );

    if (rows.length > 0) {
      const user = rows[0];
      const passCompare = req.body.password === user.password;

      if (passCompare) {
        const data = {
          user: {
            id: user.id,
          },
        };

        const token = jwt.sign(data, "secret_ecom");
        res.json({ success: true, token });
      } else {
        res.json({ success: false, errors: "Wrong Password" });
      }
    } else {
      res.json({ success: false, errors: "Wrong Username" });
    }
  } catch (error) {
    res.status(500).json({ success: false, errors: error.message });
  } finally {
    await connection.end();
  }
});

// Updated API to fetch profileImage
app.post("/api/profileImage", async (req, res) => {
  const connection = await mysql.createConnection(dbConfig);

  try {
    const { username } = req.body;
    const [rows] = await connection.execute(
      "SELECT profileImageUrl FROM colleagues WHERE name = ?",
      [username]
    );

    if (rows.length > 0 && rows[0].profileImageUrl) {
      res.json({ success: true, profileImageUrl: rows[0].profileImageUrl });
    } else {
      res.json({ success: false, message: "Profile image not found" });
    }
  } catch (error) {
    res.status(500).json({ success: false, errors: error.message });
  } finally {
    await connection.end();
  }
});

// Add this endpoint to your existing backend code
app.get("/api/applied-loans", async (req, res) => {
  const connection = await mysql.createConnection(dbConfig);

  try {
    const [rows] = await connection.execute("SELECT * FROM applied_loans");
    res.json({ success: true, loans: rows });
  } catch (error) {
    res.status(500).json({ success: false, errors: error.message });
  } finally {
    await connection.end();
  }
});

// Add this endpoint to your existing backend code
app.get("/api/taken-loans", async (req, res) => {
  const connection = await mysql.createConnection(dbConfig);

  try {
    const [rows] = await connection.execute("SELECT * FROM taken_loans");
    res.json({ success: true, loans: rows });
  } catch (error) {
    res.status(500).json({ success: false, errors: error.message });
  } finally {
    await connection.end();
  }
});

app.get("/getMember/:id_number", async (req, res) => {
  const connection = await mysql.createConnection(dbConfig);
  const id_number = req.params.id_number;

  try {
    const [rows] = await connection.execute(
      "SELECT * FROM members WHERE id_number = ?",
      [id_number]
    );
    if (rows.length > 0) {
      res.json({ success: true, member: rows[0] });
    } else {
      res.json({ success: false, errors: "Member not found" });
    }
  } catch (error) {
    res.status(500).json({ success: false, errors: error.message });
  } finally {
    await connection.end();
  }
});

// Creating API to get all inactive members
app.get("/getInactiveMembers", async (req, res) => {
  const connection = await mysql.createConnection(dbConfig);

  try {
    const [rows] = await connection.execute("SELECT * FROM inactive_members");
    res.json({ success: true, members: rows });
  } catch (error) {
    res.status(500).json({ success: false, errors: error.message });
  } finally {
    await connection.end();
  }
});

// Creating API for adding a member
app.post("/addMember", async (req, res) => {
  const connection = await mysql.createConnection(dbConfig);

  try {
    const {
      registration_number,
      id_number,
      name,
      phone_number,
      acc_number,
      county,
      location,
      email_address,
      next_of_kin_id_number,
      next_of_kin_name,
      relationship,
      next_of_kin_phone_number,
    } = req.body;

    const [result] = await connection.execute(
      "INSERT INTO members (registration_number, id_number, name, phone_number, acc_number, county, location, email_address, next_of_kin_id_number, next_of_kin_name, relationship, next_of_kin_phone_number) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)",
      [
        registration_number,
        id_number,
        name,
        phone_number,
        acc_number,
        county,
        location,
        email_address,
        next_of_kin_id_number,
        next_of_kin_name,
        relationship,
        next_of_kin_phone_number,
      ]
    );

    res.json({ success: true, message: "Member added successfully" });
  } catch (error) {
    res.status(500).json({ success: false, errors: error.message });
  } finally {
    await connection.end();
  }
});

// Creating API to get all members
app.get("/getMembers", async (req, res) => {
  const connection = await mysql.createConnection(dbConfig);

  try {
    const [rows] = await connection.execute("SELECT * FROM members");
    res.json({ success: true, members: rows });
  } catch (error) {
    res.status(500).json({ success: false, errors: error.message });
  } finally {
    await connection.end();
  }
});

// Creating API to delete a member and add to inactive members
app.delete("/deleteMember/:id_number", async (req, res) => {
  const connection = await mysql.createConnection(dbConfig);
  const id_number = req.params.id_number;

  try {
    // Start a transaction
    await connection.beginTransaction();

    // Get the member details
    const [memberRows] = await connection.execute(
      "SELECT * FROM members WHERE id_number = ?",
      [id_number]
    );

    if (memberRows.length === 0) {
      return res.json({ success: false, errors: "Member not found" });
    }

    const member = memberRows[0];

    // Insert the member into the inactive_members table
    const [insertResult] = await connection.execute(
      "INSERT INTO inactive_members (registration_number, id_number, name, phone_number, acc_number, county, location, email_address, next_of_kin_id_number, next_of_kin_name, relationship, next_of_kin_phone_number) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)",
      [
        member.registration_number,
        member.id_number,
        member.name,
        member.phone_number,
        member.acc_number,
        member.county,
        member.location,
        member.email_address,
        member.next_of_kin_id_number,
        member.next_of_kin_name,
        member.relationship,
        member.next_of_kin_phone_number,
      ]
    );

    // Delete the member from the members table
    const [deleteResult] = await connection.execute(
      "DELETE FROM members WHERE id_number = ?",
      [id_number]
    );

    // Commit the transaction
    await connection.commit();

    res.json({ success: true, message: "Member deleted successfully" });
  } catch (error) {
    // Rollback the transaction in case of error
    await connection.rollback();
    res.status(500).json({ success: false, errors: error.message });
  } finally {
    await connection.end();
  }
});

// Creating API to modify a member
app.put("/modifyMember/:id_number", async (req, res) => {
  const connection = await mysql.createConnection(dbConfig);
  const id_number = req.params.id_number;

  try {
    const {
      registration_number,
      name,
      phone_number,
      acc_number,
      county,
      location,
      email_address,
      next_of_kin_id_number,
      next_of_kin_name,
      relationship,
      next_of_kin_phone_number,
    } = req.body;

    const [result] = await connection.execute(
      "UPDATE members SET registration_number = ?, name = ?, phone_number = ?, acc_number = ?, county = ?, location = ?, email_address = ?, next_of_kin_id_number = ?, next_of_kin_name = ?, relationship = ?, next_of_kin_phone_number = ? WHERE id_number = ?",
      [
        registration_number,
        name,
        phone_number,
        acc_number,
        county,
        location,
        email_address,
        next_of_kin_id_number,
        next_of_kin_name,
        relationship,
        next_of_kin_phone_number,
        id_number,
      ]
    );

    res.json({ success: true, message: "Member updated successfully" });
  } catch (error) {
    res.status(500).json({ success: false, errors: error.message });
  } finally {
    await connection.end();
  }
});

// API to get all events
app.get("/api/events", async (req, res) => {
  const connection = await mysql.createConnection(dbConfig);

  try {
    const [rows] = await connection.execute(
      "SELECT * FROM events ORDER BY date"
    );

    // Add the recurring event for the current month if it doesn't exist
    const currentDate = new Date();
    const recurringEvent = {
      date: `${currentDate.getFullYear()}-${String(
        currentDate.getMonth() + 1
      ).padStart(2, "0")}-12`,
      name: "Contribution Deadline",
      description:
        "This is the contribution deadline that occurs on the 12th of every month.",
      emoji: "📅",
    };

    const existingRecurringEvent = rows.find(
      (event) =>
        event.name === recurringEvent.name &&
        event.emoji === recurringEvent.emoji
    );

    if (!existingRecurringEvent) {
      rows.push(recurringEvent);
    }

    res.json(rows);
  } catch (error) {
    res.status(500).json({ success: false, errors: error.message });
  } finally {
    await connection.end();
  }
});

// API to add a new event
app.post("/api/events/add", async (req, res) => {
  const connection = await mysql.createConnection(dbConfig);

  try {
    const { date, name, description, emoji } = req.body;

    await connection.execute(
      "INSERT INTO events (date, name, description, emoji) VALUES (?, ?, ?, ?)",
      [date, name, description, emoji]
    );

    res.json({ success: true, message: "Event added successfully" });
  } catch (error) {
    res.status(500).json({ success: false, errors: error.message });
  } finally {
    await connection.end();
  }
});

// API to delete an event
app.delete("/api/events/delete/:id", async (req, res) => {
  const connection = await mysql.createConnection(dbConfig);

  try {
    const { id } = req.params;

    await connection.execute("DELETE FROM events WHERE id = ?", [id]);

    res.json({ success: true, message: "Event deleted successfully" });
  } catch (error) {
    res.status(500).json({ success: false, errors: error.message });
  } finally {
    await connection.end();
  }
});

// Get all loan types
app.get("/api/loan-types", async (req, res) => {
  const connection = await mysql.createConnection(dbConfig);

  try {
    const [rows] = await connection.execute("SELECT * FROM loan_type");
    res.json({ success: true, loanTypes: rows });
  } catch (error) {
    res.status(500).json({ success: false, errors: error.message });
  } finally {
    await connection.end();
  }
});

// Add a new loan type
app.post("/api/loan-types", async (req, res) => {
  const connection = await mysql.createConnection(dbConfig);

  try {
    const { name, description } = req.body;

    const [result] = await connection.execute(
      "INSERT INTO loan_type (name, description) VALUES (?, ?)",
      [name, description]
    );

    res.json({ success: true, message: "Loan type added successfully" });
  } catch (error) {
    res.status(500).json({ success: false, errors: error.message });
  } finally {
    await connection.end();
  }
});

// Delete a loan type
app.delete("/api/loan-types/:id", async (req, res) => {
  const connection = await mysql.createConnection(dbConfig);
  const id = req.params.id;

  try {
    const [result] = await connection.execute(
      "DELETE FROM loan_type WHERE id = ?",
      [id]
    );

    res.json({ success: true, message: "Loan type deleted successfully" });
  } catch (error) {
    res.status(500).json({ success: false, errors: error.message });
  } finally {
    await connection.end();
  }
});

app.get("/api/loan-plans", async (req, res) => {
  const connection = await mysql.createConnection(dbConfig);

  try {
    const [rows] = await connection.execute("SELECT * FROM loan_plan");
    res.json({ success: true, loanPlans: rows });
  } catch (error) {
    res.status(500).json({ success: false, errors: error.message });
  } finally {
    await connection.end();
  }
});

// API to add a new loan plan
app.post("/api/loan-plans", async (req, res) => {
  const connection = await mysql.createConnection(dbConfig);

  try {
    const { period, interest, penalty } = req.body;

    const [result] = await connection.execute(
      "INSERT INTO loan_plan (period, interest, penalty) VALUES (?, ?, ?)",
      [period, interest, penalty]
    );

    res.json({ success: true, message: "Loan plan added successfully" });
  } catch (error) {
    res.status(500).json({ success: false, errors: error.message });
  } finally {
    await connection.end();
  }
});

// API to delete a loan plan
app.delete("/api/loan-plans/:id", async (req, res) => {
  const connection = await mysql.createConnection(dbConfig);
  const id = req.params.id;

  try {
    const [result] = await connection.execute(
      "DELETE FROM loan_plan WHERE id = ?",
      [id]
    );

    res.json({ success: true, message: "Loan plan deleted successfully" });
  } catch (error) {
    res.status(500).json({ success: false, errors: error.message });
  } finally {
    await connection.end();
  }
});

// API to get the sum of the amount field in the taken_loans table
app.get("/api/sum-taken-loans", async (req, res) => {
  const connection = await mysql.createConnection(dbConfig);

  try {
    const [rows] = await connection.execute(
      "SELECT SUM(amount) AS total FROM taken_loans"
    );
    const totalAmount = rows[0].total || 0;
    res.json({ success: true, totalAmount });
  } catch (error) {
    res.status(500).json({ success: false, errors: error.message });
  } finally {
    await connection.end();
  }
});

// API to get the sum of the amount field in the applied_loans table
app.get("/api/sum-applied-loans", async (req, res) => {
  const connection = await mysql.createConnection(dbConfig);

  try {
    const [rows] = await connection.execute(
      "SELECT SUM(amount) AS total FROM applied_loans"
    );
    const totalAmount = rows[0].total || 0;
    res.json({ success: true, totalAmount });
  } catch (error) {
    res.status(500).json({ success: false, errors: error.message });
  } finally {
    await connection.end();
  }
});

// Fetch all fines
app.get("/api/fines", async (req, res) => {
  const connection = await mysql.createConnection(dbConfig);

  try {
    const [rows] = await connection.execute("SELECT * FROM fines");
    res.json({ success: true, fines: rows });
  } catch (error) {
    res.status(500).json({ success: false, errors: error.message });
  } finally {
    await connection.end();
  }
});

// Add a new fine
app.post("/api/fines", async (req, res) => {
  const connection = await mysql.createConnection(dbConfig);

  try {
    const { date, person, reason, amount, fined } = req.body;

    const [result] = await connection.execute(
      "INSERT INTO fines (date, person, reason, amount, fined) VALUES (?, ?, ?, ?, ?)",
      [date, person, reason, amount, fined]
    );

    res.json({ success: true, message: "Fine added successfully" });
  } catch (error) {
    res.status(500).json({ success: false, errors: error.message });
  } finally {
    await connection.end();
  }
});

//api to send sms
app.post("/sendsms", async (req, res) => {
  const { message, mobile } = req.body;

  try {
    const response = await axios.post(
      "https://sms.textsms.co.ke/api/services/sendsms/",
      {
        apikey: "334560520899ec971bfc767c1df7bd94",
        partnerID: "10250",
        message,
        shortcode: "TextSMS",
        mobile,
      }
    );

    res.json(response.data);
  } catch (error) {
    console.error(error);
    res.status(500).send("Error sending SMS");
  }
});

// Add this endpoint to your existing backend code
app.get("/api/member-phone/:name", async (req, res) => {
  const connection = await mysql.createConnection(dbConfig);
  const name = req.params.name;

  try {
    const [rows] = await connection.execute(
      "SELECT phone_number FROM members WHERE name = ?",
      [name]
    );
    if (rows.length > 0) {
      res.json({ success: true, phone_number: rows[0].phone_number });
    } else {
      res.json({ success: false, errors: "Member not found" });
    }
  } catch (error) {
    res.status(500).json({ success: false, errors: error.message });
  } finally {
    await connection.end();
  }
});
app.get("/api/payments", async (req, res) => {
  const connection = await mysql.createConnection(dbConfig);

  try {
    const [rows] = await connection.execute("SELECT * FROM payments");
    res.json({ success: true, payments: rows });
  } catch (error) {
    res.status(500).json({ success: false, errors: error.message });
  } finally {
    await connection.end();
  }
});

// Add this endpoint to your existing backend code
app.get("/api/sum-payments/:type", async (req, res) => {
  const connection = await mysql.createConnection(dbConfig);
  const type = req.params.type;

  try {
    const [rows] = await connection.execute(
      "SELECT SUM(amount) AS total FROM payments WHERE payment = ?",
      [type]
    );
    const totalAmount = rows[0].total || 0;
    res.json({ success: true, totalAmount });
  } catch (error) {
    res.status(500).json({ success: false, errors: error.message });
  } finally {
    await connection.end();
  }
});

// API to get taken loans for a specific member
app.get("/api/member-loans/:member_name", async (req, res) => {
  const connection = await mysql.createConnection(dbConfig);
  const member_name = req.params.member_name;

  try {
    const [rows] = await connection.execute(
      "SELECT * FROM taken_loans WHERE loanee = ?",
      [member_name]
    );
    res.json({ success: true, loans: rows });
  } catch (error) {
    res.status(500).json({ success: false, errors: error.message });
  } finally {
    await connection.end();
  }
});

app.post("/api/apply-loan", async (req, res) => {
  const connection = await mysql.createConnection(dbConfig);

  try {
    const {
      loanee,
      guarantors,
      amount,
      loanType,
      loanPlanDuration,
      loanPlanInterest,
      loanPlanPenalty,
    } = req.body;

    await connection.execute(
      "INSERT INTO applied_loans (loanee, guarantors, amount, loantype, loanplan_duration, loanplan_interest, loanplan_penalty) VALUES (?, ?, ?, ?, ?, ?, ?)",
      [
        loanee,
        guarantors,
        amount,
        loanType,
        loanPlanDuration,
        loanPlanInterest,
        loanPlanPenalty,
      ]
    );

    res.json({ success: true, message: "Loan applied successfully" });
  } catch (error) {
    res.status(500).json({ success: false, errors: error.message });
  } finally {
    await connection.end();
  }
});

app.get("/api/loan-plans", async (req, res) => {
  const connection = await mysql.createConnection(dbConfig);

  try {
    const [rows] = await connection.execute("SELECT * FROM loan_plan");
    res.json({ success: true, loanPlans: rows });
  } catch (error) {
    res.status(500).json({ success: false, errors: error.message });
  } finally {
    await connection.end();
  }
});

app.get("/api/loan-types", async (req, res) => {
  const connection = await mysql.createConnection(dbConfig);

  try {
    const [rows] = await connection.execute("SELECT * FROM loan_type");
    res.json({ success: true, loanTypes: rows });
  } catch (error) {
    res.status(500).json({ success: false, errors: error.message });
  } finally {
    await connection.end();
  }
});

app.post("/api/calculate-loan", async (req, res) => {
  const connection = await mysql.createConnection(dbConfig);

  try {
    const { amount, loanPlanId } = req.body;

    const [loanPlanRows] = await connection.execute(
      "SELECT * FROM loan_plan WHERE id = ?",
      [loanPlanId]
    );

    if (loanPlanRows.length === 0) {
      return res
        .status(404)
        .json({ success: false, errors: "Loan plan not found" });
    }

    const loanPlan = loanPlanRows[0];
    const interest = (amount * loanPlan.interest) / 100;
    const penalty = (amount * loanPlan.penalty) / 100;
    const totalPayable = amount + interest;
    const monthlyPayable = totalPayable / loanPlan.period;

    res.json({
      success: true,
      totalPayable,
      monthlyPayable,
      penalty,
    });
  } catch (error) {
    res.status(500).json({ success: false, errors: error.message });
  } finally {
    await connection.end();
  }
});

app.post("/api/apply-loan", async (req, res) => {
  const connection = await mysql.createConnection(dbConfig);

  try {
    console.log("Received full request body:", req.body);

    // Destructure with default values
    const {
      loanee = "",
      guarantors = "",
      amount = 0,
      loanType = "",
      loanPlanDuration = 0,
      loanPlanInterest = 0,
      loanPlanPenalty = 0,
    } = req.body;

    console.log("Destructured data:");
    console.log("loanee:", loanee);
    console.log("guarantors:", guarantors);
    console.log("amount:", amount);
    console.log("loanType:", loanType);
    console.log("loanPlanDuration:", loanPlanDuration);
    console.log("loanPlanInterest:", loanPlanInterest);
    console.log("loanPlanPenalty:", loanPlanPenalty);

    // Validate that all required fields are present
    if (
      !loanee ||
      !guarantors ||
      !amount ||
      !loanType ||
      !loanPlanDuration ||
      !loanPlanInterest ||
      !loanPlanPenalty
    ) {
      return res
        .status(400)
        .json({ success: false, errors: "Missing required fields" });
    }

    const [result] = await connection.execute(
      "INSERT INTO applied_loans (loanee, guarantors, amount, loantype, loanplan_duration, loanplan_interest, loanplan_penalty) VALUES (?, ?, ?, ?, ?, ?, ?)",
      [
        loanee,
        guarantors,
        amount,
        loanType,
        loanPlanDuration,
        loanPlanInterest,
        loanPlanPenalty,
      ]
    );

    console.log("Loan application inserted:", result);

    res.json({ success: true, message: "Loan applied successfully" });
  } catch (error) {
    console.error("Error applying loan:", error);
    res.status(500).json({ success: false, errors: error.message });
  } finally {
    await connection.end();
  }
});
// // ACCESS TOKEN FUNCTION - use 'axios'
// async function getAccessToken() {
//   const consumer_key = "wgyJ70PrVb0tqjWFzV0Ohf9dWvjeRLnWv3o6mnVvn1T6ujYU"; // REPLACE IT WITH YOUR CONSUMER KEY
//   const consumer_secret =
//     "8xBYhJ0AnXCxOozXXUrTq5ZGByR45GJ11G3vejbby4fZRjb0tlGWEqL16GCcKQVv"; // REPLACE IT WITH YOUR CONSUMER SECRET
//   const url =
//     "https://api.safaricom.co.ke/oauth/v1/generate";
//   const auth =
//     "Basic " +
//     new Buffer.from(consumer_key + ":" + consumer_secret).toString("base64");

//   try {
//     const response = await axios.get(url, {
//       headers: {
//         Authorization: auth,
//       },
//     });

//     const dataresponse = response.data;
//     // console.log(data);
//     const accessToken = dataresponse.access_token;
//     return accessToken;
//   } catch (error) {
//     throw error;
//   }
// }

// //ACCESS TOKEN ROUTE
// app.get("/access_token", (req, res) => {
//   getAccessToken()
//     .then((accessToken) => {
//       res.send("😀 Your access token is " + accessToken);
//     })
//     .catch(console.log);
// });

// app.post("/stkpush", (req, res) => {
//   const { amount, phoneNumber } = req.body;
//   if (!amount) {
//     return res.status(400).send("❌ Amount is required");
//   }

//   getAccessToken()
//     .then((accessToken) => {
//       const url =
//         "https://api.safaricom.co.ke/mpesa/stkpush/v1/processrequest";
//       const auth = "Bearer " + accessToken;
//       const timestamp = moment().format("YYYYMMDDHHmmss");

//       const password = new Buffer.from(
//         "4972462"+
//           "4408d89a4e933c7fb3362570fd721396a1f0cebdd82e5703f65361e92e2a0602" +
//           timestamp
//       ).toString("base64");

//       axios
//         .post(
//           url,
//           {
//             BusinessShortCode: "4972463",
//             Password: password,
//             Timestamp: timestamp,
//             TransactionType: "CustomerPayBillOnline",
//             Amount: amount, // Use the amount from the request
//             PartyA: phoneNumber, // phone number to receive the stk push
//             PartyB: "4972462",
//             PhoneNumber: phoneNumber,
//             CallBackURL: "https://noidhousingbackend.mathenoid.com/stkCallback",
//             AccountReference: "mathenoid labs",
//             TransactionDesc: "Mpesa Daraja API stk push test",
//           },
//           {
//             headers: {
//               Authorization: auth,
//             },
//           }
//         )
//         .then((response) => {
//           res.send("enter pin to pay");
//         })
//         .catch((error) => {
//           console.log(error);
//           res.status(500).send("❌ Request failed");
//         });
//     })
//     .catch(console.log);
// });

// ACCESS TOKEN FUNCTION - use 'axios'
async function getAccessToken() {
  const consumer_key = "wgyJ70PrVb0tqjWFzV0Ohf9dWvjeRLnWv3o6mnVvn1T6ujYU";
  const consumer_secret =
    "8xBYhJ0AnXCxOozXXUrTq5ZGByR45GJ11G3vejbby4fZRjb0tlGWEqL16GCcKQVv";
  const url = "https://api.safaricom.co.ke/oauth/v1/generate";
  const auth =
    "Basic " +
    new Buffer.from(consumer_key + ":" + consumer_secret).toString("base64");

  try {
    const response = await axios.get(url, {
      headers: {
        Authorization: auth,
      },
      params: {
        grant_type: "client_credentials",
      },
    });

    console.log("Token Response:", response.data); // Log full response
    const accessToken = response.data.access_token;

    if (!accessToken) {
      throw new Error("No access token in response");
    }

    return accessToken;
  } catch (error) {
    console.error("Access Token Error:", error.response?.data || error.message);
    throw error;
  }
}
//ACCESS TOKEN ROUTE
app.get("/access_token", (req, res) => {
  getAccessToken()
    .then((accessToken) => {
      res.send("😀 Your access token is " + accessToken);
    })
    .catch(console.log);
});

app.post("/stkpush", async (req, res) => {
  const { amount, phoneNumber } = req.body;

  if (!amount || !phoneNumber) {
    return res.status(400).send("Amount and phoneNumber are required");
  }

  try {
    const accessToken = await getAccessToken();
    const url = "https://api.safaricom.co.ke/mpesa/stkpush/v1/processrequest";
    const auth = "Bearer " + accessToken;
    const timestamp = moment().format("YYYYMMDDHHmmss");

    const password = new Buffer.from(
      "4972462" +
        "4408d89a4e933c7fb3362570fd721396a1f0cebdd82e5703f65361e92e2a0602" +
        timestamp
    ).toString("base64");

    const response = await axios.post(
      url,
      {
        BusinessShortCode: "4972462",
        Password: password,
        Timestamp: timestamp,
        TransactionType: "CustomerPayBillOnline",
        Amount: amount,
        PartyA: phoneNumber,
        PartyB: "4972462",
        PhoneNumber: phoneNumber,
        CallBackURL: "https://kiamabackend.mathenoid.com/stkCallback",
        AccountReference: "4972462",
        TransactionDesc: "Mpesa Daraja API stk push test",
      },
      {
        headers: {
          Authorization: auth,
        },
      }
    );
    console.log("STK Response:", response.data);
    res.send("Enter pin to pay");
  } catch (error) {
    console.error("Error during STK Push request:", error);
    res.status(500).send("Request failed");
  }
});

// API to verify if a registration number belongs to an active member
app.get("/api/verify-member/:registration_number", async (req, res) => {
  const connection = await mysql.createConnection(dbConfig);
  const registration_number = req.params.registration_number;

  try {
    const [rows] = await connection.execute(
      "SELECT * FROM members WHERE registration_number = ?",
      [registration_number]
    );
    if (rows.length > 0) {
      res.json({ success: true, member: rows[0] });
    } else {
      res.json({ success: false, errors: "Member not found" });
    }
  } catch (error) {
    res.status(500).json({ success: false, errors: error.message });
  } finally {
    await connection.end();
  }
});

app.post("/api/approve-loan/:id", async (req, res) => {
  const connection = await mysql.createConnection(dbConfig);
  const loanId = req.params.id;

  try {
    await connection.beginTransaction();

    // Fetch the loan from applied_loans
    const [appliedLoan] = await connection.execute(
      "SELECT * FROM applied_loans WHERE id = ?",
      [loanId]
    );

    if (appliedLoan.length === 0) {
      await connection.rollback();
      return res.status(404).json({ success: false, errors: "Loan not found" });
    }

    const loan = appliedLoan[0];

    // Insert into taken_loans
    await connection.execute(
      "INSERT INTO taken_loans (loanee, loantype, loanplan, date, amount, duedate, comply, guarantors) VALUES (?, ?, ?, NOW(), ?, DATE_ADD(NOW(), INTERVAL ? MONTH), 'ongoing', ?)",
      [
        loan.loanee,
        loan.loantype,
        `${loan.loanplan_duration} months, ${loan.loanplan_interest}% interest, ${loan.loanplan_penalty}% penalty`,
        loan.amount,
        loan.loanplan_duration,
        loan.guarantors.replace(/ /g, "\n"),
      ]
    );

    // Delete from applied_loans
    await connection.execute("DELETE FROM applied_loans WHERE id = ?", [
      loanId,
    ]);

    await connection.commit();
    res.json({ success: true, message: "Loan approved successfully" });
  } catch (error) {
    await connection.rollback();
    res.status(500).json({ success: false, errors: error.message });
  } finally {
    await connection.end();
  }
});

app.post("/api/reject-loan/:id", async (req, res) => {
  const connection = await mysql.createConnection(dbConfig);
  const loanId = req.params.id;

  try {
    await connection.beginTransaction();

    // Fetch the loan from applied_loans
    const [appliedLoan] = await connection.execute(
      "SELECT * FROM applied_loans WHERE id = ?",
      [loanId]
    );

    if (appliedLoan.length === 0) {
      await connection.rollback();
      return res.status(404).json({ success: false, errors: "Loan not found" });
    }

    const loan = appliedLoan[0];

    // Fetch member's phone number
    const [memberRows] = await connection.execute(
      "SELECT phone_number FROM members WHERE name = ?",
      [loan.loanee]
    );

    if (memberRows.length === 0) {
      await connection.rollback();
      return res
        .status(404)
        .json({ success: false, errors: "Member not found" });
    }

    const phoneNumber = memberRows[0].phone_number;

    // Delete from applied_loans
    await connection.execute("DELETE FROM applied_loans WHERE id = ?", [
      loanId,
    ]);

    await connection.commit();

    // Send SMS
    const message = `Dear ${loan.loanee}, we regret to inform you that your loan application of ${loan.amount} has been declined.`;

    try {
      await axios.post("http://localhost:3000/sendsms", {
        message,
        mobile: phoneNumber,
      });
    } catch (smsError) {
      console.error("Error sending SMS:", smsError);
      // Note: We don't return here as the loan has already been rejected
    }

    res.json({ success: true, message: "Loan rejected and SMS sent" });
  } catch (error) {
    await connection.rollback();
    res.status(500).json({ success: false, errors: error.message });
  } finally {
    await connection.end();
  }
});

// API to get guarantee requests for a user
app.get("/api/guarantee-requests", async (req, res) => {
  const connection = await mysql.createConnection(dbConfig);
  const { registration_number } = req.body;

  try {
    const [rows] = await connection.execute(
      "SELECT * FROM applied_loans WHERE guarantors LIKE CONCAT('%\n', ?, '\n%') OR guarantors LIKE CONCAT(?, '\n%') OR guarantors LIKE CONCAT('%\n', ?) OR guarantors = ?",
      [
        registration_number,
        registration_number,
        registration_number,
        registration_number,
      ]
    );

    res.json({ success: true, guaranteeRequests: rows });
  } catch (error) {
    res.status(500).json({ success: false, errors: error.message });
  } finally {
    await connection.end();
  }
});

app.get("/api/guarantee-requests/:registration_number", async (req, res) => {
  const connection = await mysql.createConnection(dbConfig);
  const registration_number = req.params.registration_number;

  try {
    const [rows] = await connection.execute(
      "SELECT * FROM applied_loans WHERE guarantors LIKE CONCAT('%\n', ?, '\n%') OR guarantors LIKE CONCAT(?, '\n%') OR guarantors LIKE CONCAT('%\n', ?) OR guarantors = ?",
      [
        registration_number,
        registration_number,
        registration_number,
        registration_number,
      ]
    );

    const loansWithNames = await Promise.all(
      rows.map(async (loan) => {
        const guarantorNames = await Promise.all(
          loan.guarantors.split(" ").map(async (regNumber) => {
            const [memberRows] = await connection.execute(
              "SELECT name FROM members WHERE registration_number = ?",
              [regNumber]
            );
            return memberRows.length > 0 ? memberRows[0].name : regNumber;
          })
        );

        return { ...loan, guarantors: guarantorNames.join(", ") };
      })
    );

    res.json({ success: true, guaranteeRequests: loansWithNames });
  } catch (error) {
    res.status(500).json({ success: false, errors: error.message });
  } finally {
    await connection.end();
  }
});

app.get("/api/my-guarantors/:registration_number", async (req, res) => {
  const connection = await mysql.createConnection(dbConfig);
  const registration_number = req.params.registration_number;

  try {
    const [rows] = await connection.execute(
      "SELECT * FROM taken_loans WHERE loanee LIKE CONCAT('%\n', ?, '\n%') OR guarantors LIKE CONCAT(?, '\n%') OR guarantors LIKE CONCAT('%\n', ?) OR guarantors = ?",
      [
        registration_number,
        registration_number,
        registration_number,
        registration_number,
      ]
    );

    const loansWithNames = await Promise.all(
      rows.map(async (loan) => {
        const guarantorNames = await Promise.all(
          loan.guarantors.split(" ").map(async (regNumber) => {
            const [memberRows] = await connection.execute(
              "SELECT name FROM members WHERE registration_number = ?",
              [regNumber]
            );
            return memberRows.length > 0 ? memberRows[0].name : regNumber;
          })
        );

        return { ...loan, guarantors: guarantorNames.join(", ") };
      })
    );

    res.json({ success: true, myGuarantors: loansWithNames });
  } catch (error) {
    res.status(500).json({ success: false, errors: error.message });
  } finally {
    await connection.end();
  }
});

app.get("/api/my-guarantees/:registration_number", async (req, res) => {
  const connection = await mysql.createConnection(dbConfig);
  const registration_number = req.params.registration_number;

  try {
    const [rows] = await connection.execute(
      "SELECT * FROM taken_loans WHERE guarantors LIKE CONCAT('%\n', ?, '\n%') OR guarantors LIKE CONCAT(?, '\n%') OR guarantors LIKE CONCAT('%\n', ?) OR guarantors = ?",
      [
        registration_number,
        registration_number,
        registration_number,
        registration_number,
      ]
    );

    const loansWithNames = await Promise.all(
      rows.map(async (loan) => {
        const guarantorNames = await Promise.all(
          loan.guarantors.split(" ").map(async (regNumber) => {
            const [memberRows] = await connection.execute(
              "SELECT name FROM members WHERE registration_number = ?",
              [regNumber]
            );
            return memberRows.length > 0 ? memberRows[0].name : regNumber;
          })
        );

        return { ...loan, guarantors: guarantorNames.join(", ") };
      })
    );

    res.json({ success: true, myGuarantees: loansWithNames });
  } catch (error) {
    res.status(500).json({ success: false, errors: error.message });
  } finally {
    await connection.end();
  }
});

// // API to get my guarantors
// app.get("/api/my-guarantors/:registration_number", async (req, res) => {
//   const connection = await mysql.createConnection(dbConfig);
//   const registration_number = req.params.registration_number;

//   try {
//     const [rows] = await connection.execute(
//       "SELECT * FROM taken_loans WHERE loanee = ?",
//       [registration_number]
//     );

//     const loansWithNames = await Promise.all(
//       rows.map(async (loan) => {
//         const guarantorNames = await Promise.all(
//           loan.guarantors.split(" ").map(async (regNumber) => {
//             const [memberRows] = await connection.execute(
//               "SELECT name FROM members WHERE registration_number = ?",
//               [regNumber]
//             );
//             return memberRows.length > 0 ? memberRows[0].name : regNumber;
//           })
//         );

//         return { ...loan, guarantors: guarantorNames.join(", ") };
//       })
//     );

//     res.json({ success: true, myGuarantors: loansWithNames });
//   } catch (error) {
//     res.status(500).json({ success: false, errors: error.message });
//   } finally {
//     await connection.end();
//   }
// });
// // API to get my guarantees
// app.get("/api/my-guarantees/:registration_number", async (req, res) => {
//   const connection = await mysql.createConnection(dbConfig);
//   const registration_number = req.params.registration_number;

//   try {
//     const [rows] = await connection.execute(
//       "SELECT * FROM taken_loans WHERE FIND_IN_SET(?, guarantors) > 0",
//       [registration_number]
//     );

//     const loansWithNames = await Promise.all(
//       rows.map(async (loan) => {
//         const guarantorNames = await Promise.all(
//           loan.guarantors.split(" ").map(async (regNumber) => {
//             const [memberRows] = await connection.execute(
//               "SELECT name FROM members WHERE registration_number = ?",
//               [regNumber]
//             );
//             return memberRows.length > 0 ? memberRows[0].name : regNumber;
//           })
//         );

//         return { ...loan, guarantors: guarantorNames.join(", ") };
//       })
//     );

//     res.json({ success: true, myGuarantees: loansWithNames });
//   } catch (error) {
//     res.status(500).json({ success: false, errors: error.message });
//   } finally {
//     await connection.end();
//   }
// });

// // API to get member name by registration number
// app.get("/api/member-name/:registration_number", async (req, res) => {
//   const connection = await mysql.createConnection(dbConfig);
//   const registration_number = req.params.registration_number;

//   try {
//     const [rows] = await connection.execute(
//       "SELECT name FROM members WHERE registration_number = ?",
//       [registration_number]
//     );
//     if (rows.length > 0) {
//       res.json({ success: true, name: rows[0].name });
//     } else {
//       res.json({ success: false, errors: "Member not found" });
//     }
//   } catch (error) {
//     res.status(500).json({ success: false, errors: error.message });
//   } finally {
//     await connection.end();
//   }
// });

// API to get registration number by user name
app.post("/api/registration-number", async (req, res) => {
  const connection = await mysql.createConnection(dbConfig);
  const { name } = req.body;

  if (!name) {
    return res.status(400).json({ success: false, errors: "Name is required" });
  }

  try {
    const [rows] = await connection.execute(
      "SELECT registration_number FROM members WHERE name = ?",
      [name]
    );
    if (rows.length > 0) {
      res.json({
        success: true,
        registration_number: rows[0].registration_number,
      });
    } else {
      res.json({ success: false, errors: "Member not found" });
    }
  } catch (error) {
    res.status(500).json({ success: false, errors: error.message });
  } finally {
    await connection.end();
  }
});

//STK PUSH CALLBACK ROUTE

// app.post("/stkCallback", (req, res) => {
//   const connection = mysql.createConnection(dbConfigt);

//   const stkCallbackResponse = req.body;
//   const logFile = "mpesaStkResponse.json";

//   // Write the response to a log file
//   fs.writeFile(logFile, JSON.stringify(stkCallbackResponse, null, 2), (err) => {
//     if (err) {
//       console.error("Error writing to log file:", err);
//       res.status(500).send("Error writing to log file");
//       return;
//     }

//     const resultcode = stkCallbackResponse.Body.stkCallback.ResultCode;

//     if (resultcode === 0) {
//       const amount =
//         stkCallbackResponse.Body.stkCallback.CallbackMetadata.Item[0].Value;
//       const receiptNumber =
//         stkCallbackResponse.Body.stkCallback.CallbackMetadata.Item[1].Value;
//       const transactionDate =
//         stkCallbackResponse.Body.stkCallback.CallbackMetadata.Item[2].Value;
//       const mobileNumber =
//         stkCallbackResponse.Body.stkCallback.CallbackMetadata.Item[3].Value;

//       const sql =
//         "INSERT INTO `pays` (number, date, receipt, amount) VALUES (?, ?, ?, ?)";
//       const values = [mobileNumber, transactionDate, receiptNumber, amount];

//       connection.query(sql, values, (error, results) => {
//         if (error) {
//           console.error("Error in database insertion:", error);
//           res.status(500).send("Error in database insertion");
//         } else {
//           res.status(200).send("Data inserted successfully");
//         }
//       });
//     } else {
//       res.status(400).send("Invalid result code");
//     }
//   });
// });

app.post("/stkCallback", (req, res) => {
  // Create a connection pool instead of a single connection
  const pool = mysql.createPool(dbConfigt);

  const stkCallbackResponse = req.body;
  const logFile = "mpesaStkResponse.json";

  // Write the response to a log file
  fs.writeFile(logFile, JSON.stringify(stkCallbackResponse, null, 2), (err) => {
    if (err) {
      console.error("Error writing to log file:", err);
      res.status(500).send("Error writing to log file");
      return;
    }

    const resultcode = stkCallbackResponse.Body.stkCallback.ResultCode;

    if (resultcode === 0) {
      const amount =
        stkCallbackResponse.Body.stkCallback.CallbackMetadata.Item[0].Value;
      const receiptNumber =
        stkCallbackResponse.Body.stkCallback.CallbackMetadata.Item[1].Value;
      const transactionDate =
        stkCallbackResponse.Body.stkCallback.CallbackMetadata.Item[3].Value;
      const mobileNumber =
        stkCallbackResponse.Body.stkCallback.CallbackMetadata.Item[4].Value;

      const sql =
        "INSERT INTO `pays` (number, date, receipt, amount) VALUES (?, ?, ?, ?)";
      const values = [mobileNumber, transactionDate, receiptNumber, amount];

      // Use the pool to execute the query
      pool.query(sql, values, (error, results) => {
        if (error) {
          console.error("Error in database insertion:", error);
          res.status(500).send("Error in database insertion");
        } else {
          res.status(200).send("Data inserted successfully");
        }

        // Close the pool when done
        pool.end((err) => {
          if (err) {
            console.error("Error closing connection pool:", err);
          }
        });
      });
    } else {
      res.status(400).send("Invalid result code");
    }
  });
});

app.listen(3000, () => {
  console.log("Server is running on port 3000");
});
