import { Header } from '@/components/Header';
import { Footer } from '@/components/Footer';
import { Button } from '@/components/ui/button';
import { Card } from '@/components/ui/card';
import { useNavigate } from 'react-router-dom';
import { Badge } from '@/components/ui/badge';
import {
  Code2,
  Smartphone,
  Globe,
  Database,
  Settings,
  Wrench,
  Zap,

} from 'lucide-react';

const Services = () => {
  const navigate = useNavigate();

  const handleContactClick = () => {
    navigate('/contact');
  };
  const services = [
    {
      icon: Code2,
      title: "Software Solutions",
      description: 'Custom software development tailored to your specific business requirements.',
      features: ['Desktop Applications', 'API Development', 'System Integration', 'Legacy Modernization'],
      color: "from-blue-500 to-cyan-500"
    },
    {
      icon: Smartphone,
      title: 'Mobile Applications',
      description: 'Native and cross-platform mobile apps that deliver exceptional user experiences.',
      features: ['React Native', 'QT', 'iOS & Android', 'App Store/ Play Store Deployment'],
      color: "from-purple-500 to-pink-500"
    },
    {
      icon: Globe,
      title: 'Web Development',
      description: 'Modern, responsive websites and web applications built with cutting-edge technologies.',
      features: ['React + Node.js', 'Responsive Design', 'SEO Optimized', 'Performance Focused'],
      color: "from-green-500 to-emerald-500"
    },
    {
      icon: Database,
      title: 'Data Analytics',
      description: 'Transform your data into actionable insights with advanced analytics solutions.',
      features: ['Business Intelligence', 'Data Visualization', 'Predictive Analytics', 'Custom Dashboards'],
      color: "from-orange-500 to-red-500"
    },
    {
      icon: Settings,
      title: 'Application Maintenance',
      description: 'Reliable ongoing support and maintenance to keep your applications running smoothly.',
      features: ['Bug Fixes', 'Performance Monitoring', 'Security Updates', '24/7 Support'],
      color: "from-violet-500 to-purple-500"
    },
    {
      icon: Wrench,
      title: 'Software Enhancement',
      description: 'Continuous improvement and feature additions to evolve your software solutions.',
      features: ['Feature Development', 'UI/UX Improvements', 'Performance Optimization', 'Technology Upgrades'],
      color: "from-red-500 to-pink-500"
    }
  ];

  const processes = [
    { step: "01", title: "Discovery", desc: "Understanding your vision and requirements" },
    { step: "02", title: "Strategy", desc: "Crafting the perfect technical approach" },
    { step: "03", title: "Development", desc: "Building with precision and innovation" },
    { step: "04", title: "Delivery", desc: "Launching your solution with ongoing support" }
  ];

  return (
    <div className="min-h-screen">
      <Header />

      {/* Hero Section */}
      <section className="pt-32 pb-16 px-4 sm:px-6 lg:px-8">
        <div className="container mx-auto text-center">
          <div className="max-w-4xl mx-auto">
            <Badge variant="outline" className="mb-6 text-primary border-primary/20 font-tech">
              Our Expertise
            </Badge>
            <h1 className="font-space-age text-5xl md:text-7xl font-bold mb-6 bg-gradient-to-r from-primary via-purple-500 to-steel-blue-light bg-clip-text text-transparent animate-hologram">
              Services That Transform
            </h1>
            <p className="text-xl text-muted-foreground mb-8 leading-relaxed font-cyber">
              From concept to deployment, we craft digital solutions that push boundaries and deliver exceptional results.
            </p>
          </div>
        </div>
      </section>

      {/* Services Grid */}
      <section className="py-16 px-4 sm:px-6 lg:px-8">
        <div className="container mx-auto">
          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            {services.map((service, index) => {
              const Icon = service.icon;
              return (
                <Card
                  key={index}
                  className="p-8 hover:shadow-2xl transition-all duration-500 border-0 bg-gradient-to-br from-background/50 to-background/80 backdrop-blur-sm group hover:scale-105"
                >
                  <div className={`w-16 h-16 rounded-2xl bg-gradient-to-r ${service.color} p-4 mb-6 group-hover:rotate-12 transition-transform duration-300`}>
                    <Icon className="w-full h-full text-white" />
                  </div>
                  <h3 className="text-2xl font-bold mb-4 text-foreground font-tech">{service.title}</h3>
                  <p className="text-muted-foreground mb-6 leading-relaxed font-cyber">{service.description}</p>
                  <ul className="space-y-2">
                    {service.features.map((feature, idx) => (
                      <li key={idx} className="flex items-center text-sm text-muted-foreground">
                        <Zap className="w-4 h-4 mr-2 text-primary" />
                        {feature}
                      </li>
                    ))}
                  </ul>
                </Card>
              );
            })}
          </div>
        </div>
      </section>

      {/* Process Section */}
      <section className="py-16 px-4 sm:px-6 lg:px-8 bg-gradient-to-b from-background to-muted/20">
        <div className="container mx-auto">
          <div className="text-center mb-16">
            <h2 className="font-space-age text-4xl md:text-5xl font-bold mb-6 bg-gradient-to-r from-primary to-steel-blue-light bg-clip-text text-transparent animate-hologram">
              Our Process
            </h2>
            <p className="text-xl text-muted-foreground max-w-2xl mx-auto font-cyber">
              A streamlined approach that ensures quality, transparency, and exceptional results at every step.
            </p>
          </div>

          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
            {processes.map((process, index) => (
              <div key={index} className="text-center group">
                <div className="relative mb-6">
                  <div className="w-20 h-20 mx-auto rounded-full bg-gradient-to-r from-primary to-steel-blue-light flex items-center justify-center text-white font-bold text-xl group-hover:scale-110 transition-transform duration-300">
                    {process.step}
                  </div>
                  {index < processes.length - 1 && (
                    <div className="hidden lg:block absolute top-10 left-1/2 w-full h-0.5 bg-gradient-to-r from-primary/50 to-steel-blue-light/50 transform translate-x-1/2"></div>
                  )}
                </div>
                <h3 className="text-xl font-bold mb-2 text-foreground">{process.title}</h3>
                <p className="text-muted-foreground">{process.desc}</p>
              </div>
            ))}
          </div>
        </div>
      </section>

      {/* CTA Section */}
      <section className="py-16 px-4 sm:px-6 lg:px-8">
        <div className="container mx-auto text-center">
          <div className="max-w-3xl mx-auto p-12 rounded-3xl bg-gradient-to-r from-primary/10 to-steel-blue-light/10 border border-primary/20">
            <h2 className="text-3xl md:text-4xl font-bold mb-6 text-foreground">
              Ready to Start Your Project?
            </h2>
            <p className="text-xl text-muted-foreground mb-8">
              Let's discuss how we can bring your vision to life with cutting-edge technology.
            </p>
            <Button size="lg"
              onClick={handleContactClick}
              className="bg-gradient-to-r from-primary to-steel-blue-light hover:opacity-90 text-white px-8 py-4 rounded-xl">
              Get Started Today
            </Button>
          </div>
        </div>
      </section>

      <Footer />
    </div>
  );
};

export default Services;