import { Header } from '@/components/Header';
import { Footer } from '@/components/Footer';
import { Button } from '@/components/ui/button';
import { Card } from '@/components/ui/card';
import { Badge } from '@/components/ui/badge';
import { 
  Target, 
  Lightbulb, 
  Heart,
  Rocket,
  Code,
  Palette,
  Brain,
  Zap,
  Users,
  Award,
  Clock,
  Star
} from 'lucide-react';

const About = () => {
  const values = [
    {
      icon: Lightbulb,
      title: "Innovation First",
      description: "We push boundaries and embrace cutting-edge technologies to create tomorrow's solutions today.",
      color: "from-yellow-500 to-orange-500"
    },
    {
      icon: Heart,
      title: "Passion Driven",
      description: "Every line of code is written with passion, every design crafted with care and attention to detail.",
      color: "from-red-500 to-pink-500"
    },
    {
      icon: Target,
      title: "Results Focused",
      description: "We measure success by the tangible impact our solutions have on our clients' businesses.",
      color: "from-blue-500 to-indigo-500"
    },
    {
      icon: Users,
      title: "Collaboration",
      description: "Great solutions emerge from great partnerships. We work closely with our clients every step of the way.",
      color: "from-green-500 to-emerald-500"
    }
  ];

  const skills = [
    { icon: Code, name: "Full-Stack Development", level: 95 },
    { icon: Palette, name: "UI/UX Design", level: 90 },
    { icon: Brain, name: "AI & Machine Learning", level: 85 },
    { icon: Zap, name: "Data Analysis", level: 92 },
  ];

  const journey = [
    {
      year: "2022",
      title: "The Beginning",
      description: "Started as a passionate developer with a vision to create innovative digital solutions.",
      milestone: "First Client Project"
    },
    {
      year: "2024",
      title: "Growing Team",
      description: "Expanded to include talented designers and developers, forming Mathenoid ICT Lab.",
      milestone: "Diversification and specialization "
    },
    {
      year: "2024",
      title: "Recognition",
      description: "Won multiple awards for innovative solutions and exceptional client satisfaction.",
      milestone: "Industry Awards"
    },
    {
      year: "2025",
      title: "Leading Innovation",
      description: "Now serving 30+ clients with cutting-edge solutions in AI, web, and mobile development.",
      milestone: "Market Leader"
    }
  ];

  const stats = [
    { icon: Award, value: "50+", label: "Projects Delivered" },
    { icon: Clock, value: "4+", label: "Years Experience" },
    { icon: Star, value: "4.9", label: "Client Rating" },
    { icon: Users, value: "30+", label: "Happy Clients" }
  ];

  return (
    <div className="min-h-screen">
      <Header />
      
      {/* Hero Section */}
      <section className="pt-32 pb-16 px-4 sm:px-6 lg:px-8">
        <div className="container mx-auto">
          <div className="grid grid-cols-1 lg:grid-cols-2 gap-16 items-center">
            <div>
              <Badge variant="outline" className="mb-6 text-primary border-primary/20 font-tech">
                About Mathenoid ICT Lab
              </Badge>
              <h1 className="font-space-age text-5xl md:text-6xl font-bold mb-6 bg-gradient-to-r from-primary via-purple-500 to-steel-blue-light bg-clip-text text-transparent animate-hologram">
                Crafting Digital Excellence
              </h1>
              <p className="text-xl text-muted-foreground mb-8 leading-relaxed font-cyber">
                We're not just developers – we're digital architects, innovation catalysts, and your partners in transforming ideas into extraordinary digital experiences.
              </p>
              <div className="flex flex-wrap gap-4">
                <Button size="lg" className="bg-gradient-to-r from-primary to-steel-blue-light hover:opacity-90 text-white font-tech neon-border animate-glow">
                  Our Story
                </Button>
                <Button variant="outline" size="lg" className="font-tech neon-border hover:bg-primary/10">
                  Meet the Team
                </Button>
              </div>
            </div>
            
            <div className="relative">
              <div className="w-full h-96 rounded-3xl bg-gradient-to-br from-primary/20 to-steel-blue-light/20 flex items-center justify-center relative overflow-hidden">
                <div className="absolute inset-0 bg-gradient-to-br from-primary/10 to-steel-blue-light/10"></div>
                <div className="relative z-10 text-center">
                  <Rocket className="w-24 h-24 text-primary mx-auto mb-4" />
                  <h3 className="text-2xl font-bold text-foreground mb-2">Innovation in Motion</h3>
                  <p className="text-muted-foreground">Turning visions into reality</p>
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>

      {/* Stats Section */}
      <section className="py-16 px-4 sm:px-6 lg:px-8 bg-gradient-to-r from-primary/5 to-steel-blue-light/5">
        <div className="container mx-auto">
          <div className="grid grid-cols-2 md:grid-cols-4 gap-8">
            {stats.map((stat, index) => {
              const Icon = stat.icon;
              return (
                <div key={index} className="text-center">
                  <Icon className="w-12 h-12 mx-auto mb-4 text-primary" />
                  <div className="text-3xl md:text-4xl font-bold text-foreground mb-2">{stat.value}</div>
                  <div className="text-muted-foreground">{stat.label}</div>
                </div>
              );
            })}
          </div>
        </div>
      </section>

      {/* Values Section */}
      <section className="py-16 px-4 sm:px-6 lg:px-8">
        <div className="container mx-auto">
          <div className="text-center mb-16">
            <h2 className="font-space-age text-4xl md:text-5xl font-bold mb-6 bg-gradient-to-r from-primary to-steel-blue-light bg-clip-text text-transparent animate-hologram">
              Our Core Values
            </h2>
            <p className="text-xl text-muted-foreground max-w-3xl mx-auto font-cyber">
              These principles guide everything we do, from the code we write to the relationships we build.
            </p>
          </div>
          
          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
            {values.map((value, index) => {
              const Icon = value.icon;
              return (
                <Card key={index} className="p-8 text-center border-0 hover:shadow-2xl transition-all duration-500 bg-gradient-to-b from-background/80 to-muted/20 group hover:scale-105">
                  <div className={`w-16 h-16 rounded-2xl bg-gradient-to-r ${value.color} p-4 mx-auto mb-6 group-hover:rotate-12 transition-transform duration-300`}>
                    <Icon className="w-full h-full text-white" />
                  </div>
                  <h3 className="text-xl font-bold mb-4 text-foreground font-tech">{value.title}</h3>
                  <p className="text-muted-foreground leading-relaxed font-cyber">{value.description}</p>
                </Card>
              );
            })}
          </div>
        </div>
      </section>

      {/* Skills Section */}
      <section className="py-16 px-4 sm:px-6 lg:px-8 bg-gradient-to-b from-background to-muted/20">
        <div className="container mx-auto">
          <div className="grid grid-cols-1 lg:grid-cols-2 gap-16 items-center">
            <div>
              <h2 className="text-4xl md:text-5xl font-bold mb-6 text-foreground">
                Expertise That Delivers
              </h2>
              <p className="text-xl text-muted-foreground mb-8 leading-relaxed">
                Our diverse skill set enables us to tackle any challenge and deliver solutions that exceed expectations.
              </p>
              
              <div className="space-y-6">
                {skills.map((skill, index) => {
                  const Icon = skill.icon;
                  return (
                    <div key={index} className="space-y-2">
                      <div className="flex items-center justify-between">
                        <div className="flex items-center">
                          <Icon className="w-5 h-5 mr-3 text-primary" />
                          <span className="font-medium text-foreground">{skill.name}</span>
                        </div>
                        <span className="text-sm text-muted-foreground">{skill.level}%</span>
                      </div>
                      <div className="w-full bg-muted rounded-full h-2">
                        <div 
                          className="bg-gradient-to-r from-primary to-steel-blue-light h-2 rounded-full transition-all duration-1000 ease-out"
                          style={{ width: `${skill.level}%` }}
                        ></div>
                      </div>
                    </div>
                  );
                })}
              </div>
            </div>
            
            <div className="relative">
              <Card className="p-8 border-0 bg-gradient-to-br from-primary/10 to-steel-blue-light/10">
                <h3 className="text-2xl font-bold mb-6 text-foreground">Technology Stack</h3>
                <div className="grid grid-cols-3 gap-4">
                  {["React", "Node.js", "Python", "TypeScript", "SQL", "QT C++", "TensorFlow", "PHP", "Firebase"].map((tech, idx) => (
                    <Badge key={idx} variant="secondary" className="justify-center py-2">
                      {tech}
                    </Badge>
                  ))}
                </div>
              </Card>
            </div>
          </div>
        </div>
      </section>

      {/* Journey Timeline */}
      <section className="py-16 px-4 sm:px-6 lg:px-8">
        <div className="container mx-auto">
          <div className="text-center mb-16">
            <h2 className="text-4xl md:text-5xl font-bold mb-6 bg-gradient-to-r from-primary to-steel-blue-light bg-clip-text text-transparent">
              Our Journey
            </h2>
            <p className="text-xl text-muted-foreground max-w-3xl mx-auto">
              From humble beginnings to industry recognition – here's how we've grown and evolved.
            </p>
          </div>
          
          <div className="relative">
            <div className="absolute left-1/2 transform -translate-x-1/2 w-1 h-full bg-gradient-to-b from-primary to-steel-blue-light rounded-full"></div>
            
            <div className="space-y-16">
              {journey.map((item, index) => (
                <div key={index} className={`flex items-center ${index % 2 === 0 ? 'flex-row-reverse' : ''}`}>
                  <div className={`w-1/2 ${index % 2 === 0 ? 'pl-8' : 'pr-8'}`}>
                    <Card className={`p-6 border-0 bg-gradient-to-br from-background/80 to-muted/20 ${index % 2 === 0 ? 'text-right' : ''}`}>
                      <div className="flex items-center justify-between mb-4">
                        <Badge variant="outline" className="text-primary border-primary/20">
                          {item.year}
                        </Badge>
                        <Badge className="bg-primary/20 text-primary border-primary/30">
                          {item.milestone}
                        </Badge>
                      </div>
                      <h3 className="text-xl font-bold mb-3 text-foreground">{item.title}</h3>
                      <p className="text-muted-foreground">{item.description}</p>
                    </Card>
                  </div>
                  
                  <div className="w-6 h-6 bg-gradient-to-r from-primary to-steel-blue-light rounded-full relative z-10 border-4 border-background"></div>
                  
                  <div className="w-1/2"></div>
                </div>
              ))}
            </div>
          </div>
        </div>
      </section>

      <Footer />
    </div>
  );
};

export default About;