import { useState, useEffect } from 'react';
import { Button } from '@/components/ui/button';
import { ArrowRight, Code, Smartphone, Database, Globe, Zap, Brain, Cpu, Atom } from 'lucide-react';
import { useNavigate, Link } from 'react-router-dom';

export const HeroSection = () => {
  const [currentText, setCurrentText] = useState('');
   const navigate = useNavigate();

 const handleProjectsClick = () => {
    navigate('/projects');
  };

  const handleContactClick = () => {
    navigate('/contact');
  };
  const [currentIndex, setCurrentIndex] = useState(0);
  const services = [
    'Websites ',
    'WebApps ',
    'Mobile Apps',
    'Consultation',
    'Distributed Systems'
  ];

  useEffect(() => {
    const typeWriter = () => {
      const currentService = services[currentIndex];
      if (currentText.length < currentService.length) {
        setCurrentText(currentService.slice(0, currentText.length + 1));
      } else {
        setTimeout(() => {
          // Smooth transition without abrupt reset
          const eraseText = () => {
            if (currentText.length > 0) {
              setCurrentText(prev => prev.slice(0, -1));
              setTimeout(eraseText, 50);
            } else {
              setCurrentIndex((prev) => (prev + 1) % services.length);
            }
          };
          setTimeout(eraseText, 1500);
        }, 1000);
      }
    };

    const timer = setTimeout(typeWriter, 80);
    return () => clearTimeout(timer);
  }, [currentText, currentIndex]);

  const CyberElement = ({ icon: Icon, className, delay = "0s" }: { icon: any, className: string, delay?: string }) => (
    <div
      className={`absolute animate-cyber-float opacity-30 z-0 ${className}`}
      style={{
        animationDelay: delay,
        animationDuration: '8s'
      }}
    >
      <div className="p-3 backdrop-blur-sm rounded-lg border border-primary/20">
        <Icon className="w-6 h-6 text-primary/50" />
      </div>
    </div>
  );

  const DataStream = ({ className }: { className: string }) => (
    <div className={`absolute ${className} overflow-hidden`}>
      <div className="w-px h-32 bg-gradient-to-b from-transparent via-primary to-transparent animate-data-stream"></div>
    </div>
  );

  const MatrixRain = ({ className }: { className: string }) => (
    <div className={`absolute ${className} font-mono-future text-xs text-primary/30 overflow-hidden`}>
      <div className="animate-matrix">01010101</div>
    </div>
  );

  return (
    <section id="home" className="relative min-h-screen flex items-center justify-center overflow-hidden">
      {/* Cyber Background */}
      <div className="absolute inset-0 bg-gradient-to-br from-background via-background/90 to-muted/20">
        {/* Scanning line effect */}
        <div className="absolute inset-0 opacity-10">
          <div className="absolute w-full h-px bg-gradient-to-r from-transparent via-primary to-transparent animate-scan-line"></div>
        </div>

        {/* Holographic grid */}
        <div className="absolute inset-0 opacity-5 holographic">
          <div className="w-full h-full" style={{
            backgroundImage: `
              linear-gradient(rgba(70, 130, 180, 0.1) 1px, transparent 1px),
              linear-gradient(90deg, rgba(70, 130, 180, 0.1) 1px, transparent 1px)
            `,
            backgroundSize: '50px 50px'
          }}></div>
        </div>
      </div>

      {/* Floating Cyber Elements */}
      <div className="absolute inset-0 pointer-events-none">
        <CyberElement icon={Brain} className="top-24 left-16" delay="0s" />
        <CyberElement icon={Cpu} className="top-40 right-24" delay="2s" />
        <CyberElement icon={Atom} className="bottom-40 left-24" delay="4s" />
        <CyberElement icon={Zap} className="bottom-24 right-16" delay="6s" />

        {/* Data streams */}
        <DataStream className="top-0 left-1/4 w-px h-full" />
        <DataStream className="top-0 right-1/3 w-px h-full" />
        <DataStream className="top-0 left-3/4 w-px h-full" />

        {/* Matrix rain */}
        <MatrixRain className="top-0 left-1/6 w-8" />
        <MatrixRain className="top-0 right-1/6 w-8" />
        <MatrixRain className="top-0 left-2/3 w-8" />

        {/* Floating geometric shapes */}
        <div className="absolute top-1/4 left-1/4 w-2 h-2 bg-primary/30 rounded-full opacity-40"></div>
        <div className="absolute top-3/4 right-1/4 w-2 h-2 bg-accent/30 rounded-full animate-pulse opacity-30"></div>
        <div className="absolute top-1/2 left-3/4 w-3 h-3 border border-primary/30 rotate-45 opacity-20"></div>
      </div>

      <div className="container mx-auto px-4 sm:px-6 lg:px-8 relative z-10">
        <div className="text-center animate-slide-up">
          {/* Hero Content */}
          <div className="max-w-5xl mx-auto">
            <h1 className="font-space-age text-5xl sm:text-6xl lg:text-8xl font-black mb-8 leading-tight">
              <span className="block text-foreground/80 font-tech text-2xl sm:text-3xl lg:text-4xl font-light mb-4 animate-fade-in">
                into the future
              </span>

              {/* Simple Mathenoid ICT Lab text */}
              <div className="font-space-age text-5xl md:text-7xl font-bold mb-6 bg-gradient-to-r from-primary via-purple-500 to-steel-blue-light bg-clip-text text-transparent animate-hologram">
                MATHENOID ICT LAB
              </div>
            </h1>

            <div className="text-2xl sm:text-3x mb-12 text-muted-foreground font-tech overflow-hidden">
              <span className="bg-gradient-to-r from-steel-blue-light via-purple-500 to-primary bg-clip-text text-transparent ">
                Pioneering: {services.join(' • ')}
              </span>
            </div>

            <p className="text-xl mb-12 max-w-3xl mx-auto text-muted-foreground leading-relaxed font-cyber">
              A cutting-edge technology laboratory pioneering innovative Websites, WebApps, Mobile Apps, Consultation services, and Distributed Systems. We transcend boundaries to create digital realities that reshape tomorrow.
            </p>

            {/* Futuristic CTA Buttons */}
            <div className="flex flex-col sm:flex-row gap-6 justify-center items-center mb-16">
              <Button
                size="lg"
               onClick={handleProjectsClick} 
                className="group bg-primary hover:bg-primary/90 text-primary-foreground px-10 py-4 font-tech text-lg neon-border"
              >
                FEATURED SOLUTIONS
                <ArrowRight className="ml-3 w-5 h-5 group-hover:translate-x-2 transition-transform" />
              </Button>

              <Button
                variant="outline"
                size="lg"
                onClick={handleContactClick}
                className="backdrop-blur-cyber border-primary text-primary hover:bg-primary hover:text-primary-foreground px-10 py-4 font-tech text-lg neon-border"
              >
                CONTACT MATHENOID
              </Button>
            </div>

            {/* Cyber Stats Grid */}
            <div className="grid grid-cols-2 md:grid-cols-4 gap-8 pt-16 border-t border-primary/30">
              {[
                { value: "100+", label: "Systems Deployed" },
                { value: "∞", label: "Computing Solutions" },
                { value: "99.9%", label: "System Uptime" },
                { value: "24/7", label: "Cyber Vigilance" }
              ].map((stat, index) => (
                <div key={index} className="text-center group">
                  <div className="text-4xl font-bold text-primary mb-2 font-space-age group-hover:scale-110 transition-transform">
                    {stat.value}
                  </div>
                  <div className="text-sm text-muted-foreground font-tech uppercase tracking-wide">
                    {stat.label}
                  </div>
                </div>
              ))}
            </div>
          </div>
        </div>
      </div>
    </section>
  );
};